// Assignment 4 : The form post servlet - a servlet that posts to itself
// This Servlet can do read/write from the random access exactly like C-random acces.
import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class formPost2 extends HttpServlet 
{
    // header1+header2 form the general header (<html><body> .. etc.) portion of the html file.
    String header1 = "<html><head><title>CIS 404 - Advanced Java - Assignment 4</title></head>";
    String header2 = "<body bgcolor=\"#CCCDF9\" text=\"#FFFFFF\" link=\"#EB5077\" vlink=\"#F4F3EA\" alink=\"#CAF8FB\">";

    // footer form the general footer (</body></html>.. etc.) portion of the html file.
    String footer= "<CENTER><BR><BR><BR><BR><BR><H5>all rights : sudip shrestha</H5></CENTER></body></html>";
    File file = new File( "/Tomcat4/webapps/ROOT/WEB-INF/classes/cisjava.dat" );

    // Set the maximum size of Strings for name, email and Comments to be stored in Random Access File.
    final int maxNameSize = 80;
    final int maxEmailSize = 80;
    final int maxCommentsSize = 300;

    // if 'doGet' runs, the user selected the servlet with a 'GET' operation. So they will 
    // receive a form to enter their name
    public void doGet(HttpServletRequest request, HttpServletResponse response)
                throws IOException, ServletException
    {
            ResourceBundle rb =
            ResourceBundle.getBundle("LocalStrings",request.getLocale());
   	    String myString1 = rb.getString("formPost.title1");
	    String myString2 = rb.getString("formPost.title2");
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();

            out.println( header1+'\n'+header2 );
	    out.println( "<BR><center>"+myString1+" Assignment</center><BR>" );
            out.println( "<form method=\"post\" action=\"/servlet/formPost2\">" );
            try
       	    {
       	    	// I did not put the main HTML stuff here (inside out.println("...")), for clarity.
            	// Create a buffered reader to read each line from a file. This file 'HTMLdata.txt'
       	    	// contains the contents of the table: which contains the form-components: such as
       	    	// textfields, textarea, buttons.
	    	File fileHTMLdata = new File( "/Tomcat4/webapps/ROOT/WEB-INF/classes/HTMLdata.txt" );
            	BufferedReader in = new BufferedReader( new FileReader( fileHTMLdata ) );
            	String s;
 
	        // Read each line from the file and echo it to the screen.
            	s = in.readLine();
            	while ( s != null )
            	{
                	out.println( s );
                	s = in.readLine();
            	}
            	// Close the buffered reader, which also closes the file reader.
            	in.close();
	   }
           catch (FileNotFoundException e)
           {
           	// If this file does not exist
            	out.println("File not found: HTMLdata.txt");
 
           } 
           catch (IOException e)
           {
            	out.println("An IO exception encountered!");
           }	
           out.println( footer );
    }

    // if 'doPost' runs, the user sent the servlet a name-value pair (name=txtName, value is the
    // value of the text box in the above form.)  So the name-value pair is decoded and printed out.
    public void doPost(HttpServletRequest request, HttpServletResponse response)
                throws IOException, ServletException
    {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println( header1+'\n'+header2 );
            // Store parameter names into respective variables. Reminder: the parameter names are in
            // the file: 'HTMLdata.txt'.
            String name=request.getParameter("txtName");
            String email=request.getParameter("txtEmail");
            String comments=request.getParameter("txtaComments");

            try
	    {
	    	// open the 'cisjava.dat' file for read write access, so that form contents can be read from and
	    	// written to this file.
	        RandomAccessFile ra = new RandomAccessFile( "/Tomcat4/webapps/ROOT/WEB-INF/classes/cisjava.dat","rw" );

	        out.println( "<center><BR>" );
            	// Write to the text file only 'iff' the name and email fields are non-empty
            	if ( name.equals("") && email.equals("") )
            	{
                    out.println( "<h2>Please Enter the text fields to record your entry!</h2>" );
            	}
            	// Check for the missing '@' and '.' characters from the 'email' string.
            	else if( email.indexOf( '@' )==-1 || email.indexOf( '.' )==-1 )
            	{
            	    out.println( "<h2>Please Enter proper Email address to record your entry!</h2>" );
                }
            	else
            	{
                   out.println( "<h2>Thank you "+name+"</h2>" );
       	    	   ra.seek( ra.length() );
		   ra.writeBytes( addTrailingSpaces( name,maxNameSize ) );
		   ra.writeBytes( addTrailingSpaces( email,maxEmailSize ) );
		   ra.writeBytes( addTrailingSpaces( comments,maxCommentsSize ) );
	    	}

	    	out.println( "<hr width=\"600\" color=\"#FF0000\">" );
	    	out.println( "<h3>Current Entries</h3><BR></center>" );
            	out.println( "<TABLE CELLPADDING=2 Border=1 align=center>" );
                out.println( "<font size=3>" );
                
            	byte [] brName=new byte[maxNameSize];
            	byte [] brEmail=new byte[maxEmailSize];
            	byte [] brComments=new byte[maxCommentsSize];

            	String s;
            	int filePosition = 0;
           	ra.seek( filePosition );
           	
            	while ( filePosition<ra.length() )
            	{
            	    out.println( "<TR><TD ALIGN=Left WIDTH=600>" );
            	    
		    // Read the name field from the random access file to the byte array 'brName'
            	    ra.read( brName );
            	    // reinitialize s
            	    s = "";
            	    // Read the byte array brName and store the corresponding string to s
            	    s = readByteArray( brName );
                    out.println( "Name: "+s.trim()+"<BR>" );
                    // Reset the filePosition to the end of the first (Name) field
                    filePosition += maxNameSize;
                    ra.seek( filePosition );

                    // Read the email field from the random access file
		    ra.read( brEmail );
		    // reinitialize s
		    s="";
		    s = readByteArray( brEmail );
                    out.println( "<em>Email: "+s.trim()+"</em><BR>" );
                    // Reset the filePosition to the end of the second (Email) field
                    filePosition += maxEmailSize;
                    ra.seek( filePosition );

                    // Read the name comments from the random access file
                    ra.read( brComments );
                    // reinitialize s
                    s="";
		    s = readByteArray( brComments );
                    out.println( "Comments: "+s.trim()+"<BR>" );
                    // Reset the filePosition to the end of the third (Comments) field
                    // This marks the end of first three entries. 
                    // ( total = (maxNameSize + maxEmailSize + maxCommentsSize) bytes )
                    filePosition += maxCommentsSize;
                    ra.seek( filePosition );

                    out.println( "</TD></TR>" );
                }
                out.println( "</font></table>" );
                ra.close();
            }
            catch (FileNotFoundException e)
            {
            	// If this file does not exist
            	out.println("File not found: cisjava.dat");
            } 
            catch (IOException e)
            {
            	out.println("An IO exception encountered!");
            }
            out.println( footer );
    }

    // This function scans the byte array 'barr' and extracts the string from it.
    public String readByteArray(byte[] barr)
    {
    	String s="";
    	ByteArrayInputStream bin = new ByteArrayInputStream( barr );
 	int ch;
 	while( ( ch=bin.read() )!=-1 )
 	{
 	    Character c = new Character( (char)ch );
 	    s += c.toString();
 	}
 	return s;
    }

    // This function adds white spaces to the given input string 's' so that its size is equal
    // to maxSize. This is useful while writing to Random Access file, as the size of the byte
    // will be fixed. Similarly, if it is more tham maxSize, it removes any string after maxSize
    // length.
    public String addTrailingSpaces(String s, int maxSize)
    {
    	int len = s.length();
    	if( len<maxSize )
    	{
    		int spaceNumber = maxSize-len-1;
    		String strSpaces = "";
    		for(int i=0; i<=spaceNumber; i++)
    		{
    			strSpaces += " ";
    		}
    		s += strSpaces;
    	}
    	else if( len>maxSize )
    	{
    		s = s.substring( 0,maxSize );
    	}
    	return s;
    }
}
